unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, XLISetting_TLB;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Panel1: TPanel;
    Controls: TButton;
    snap: TButton;
    highres: TCheckBox;
    Panel2: TPanel;
    ColourButton: TRadioButton;
    MonoButton: TRadioButton;
    RawBayerButton: TRadioButton;
    Annotate: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure ControlsClick(Sender: TObject);
    procedure snapClick(Sender: TObject);
    function GrabImage : TBitmap;
    procedure FormCreate(Sender: TObject);
    procedure UpDown1Click(Sender: TObject; Button: TUDBtnType);
    procedure highresClick(Sender: TObject);
    procedure ColourButtonClick(Sender: TObject);
    procedure MonoButtonClick(Sender: TObject);
    procedure RawBayerButtonClick(Sender: TObject);
    procedure AnnotateClick(Sender: TObject);
  private
    { Private declarations }
  public
   xlisetting : IXLISetting;
   camera : integer;
   resolution : integer;
    { Public declarations }
  end;

var
  Form1: TForm1;


implementation

{$R *.DFM}


procedure TForm1.Button1Click(Sender: TObject);
var
   status : integer;
   SDKversion : word;
begin
   xlisetting := coxli_setting.create;
   status := xlisetting.SelectDevice(camera,resolution,Panel1.Handle);
   if status = 0 then
      showmessage('Camera not found')
   else begin
      SDKversion := xlisetting.GetVal(XLVERSION);
      Form1.Caption := format('This is using SDK Version %d.0%d',[hi(SDKversion),lo(SDKversion)]);
      //If status is not zero, you can be cast it as an IBaseFilter
      button1.Enabled := false;
      controls.Enabled := true;
      annotate.Enabled := true;
      highres.Enabled := true;
      monobutton.Enabled := true;
      colourbutton.Enabled := true;
      rawbayerbutton.Enabled := true;
      snap.Enabled := true;
   end;
end;

procedure TForm1.ControlsClick(Sender: TObject);
var
   wnd : HWND;
   rect : TRect;
begin
  getwindowrect(panel1.Handle,rect);
  //wnd := xlisetting.ShowPropertyPage(rect.right,rect.top);
  wnd := xlisetting.CameraControls(Handle,0,0);
  setwindowtext(wnd,'Hello World');
end;


function TForm1.GrabImage : TBitmap;
var
   bufptr, bufptr2: Pbyte;
   bufsize: dword;
   w,h : Integer; 
   bitmap : TBitmap;
begin
   bufptr := pbyte(xlisetting.grab);
   if bufptr = nil then begin
      result := nil;
      exit;
   end;
   xlisetting.GetResolution(w,h);
   bitmap := TBitmap.Create;
   bitmap.PixelFormat := pf24bit;
   bitmap.Width := w;
   bitmap.Height := h;
   bufptr2 := bitmap.ScanLine[h-1]; //start of image buffer.
   bufsize := w * h * 3;
   copymemory(bufptr2,bufptr,bufsize);
   result := bitmap;
end;



procedure TForm1.snapClick(Sender: TObject);
var
   bitmap : TBitmap;
begin
   bitmap := grabimage;
   if bitmap = nil then
      showmessage('Snapshot failed')
   else begin
      bitmap.SaveToFile('sample.bmp');
      bitmap.Free;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  camera := 1;
  resolution := 0;
end;

procedure TForm1.UpDown1Click(Sender: TObject; Button: TUDBtnType);
var
  offset : integer;
begin
  if button = btprev then
    offset := -1
  else
    offset := 1;
  if xlisetting.SelectDevice(camera+offset,resolution,Panel1.Handle) <> 0 then
    camera := camera + offset
  else
    xlisetting.SelectDevice(camera,resolution,Panel1.handle);
end;

procedure TForm1.highresClick(Sender: TObject);
begin
  resolution := integer(not highres.checked);
  if xlisetting.SelectDevice(camera,resolution,Panel1.Handle) = 0 then
    showmessage('Camera not found')
  else
    AnnotateClick(sender);
end;

procedure TForm1.ColourButtonClick(Sender: TObject);
begin
  XLISetting.SetVal(XLPROCESSINGMODE,1);
end;

procedure TForm1.MonoButtonClick(Sender: TObject);
begin
  XLISetting.SetVal(XLPROCESSINGMODE,0);
end;

procedure TForm1.RawBayerButtonClick(Sender: TObject);
begin
  Xlisetting.SetVal(XLPROCESSINGMODE,2);
end;

var
  textid : integer;

procedure TForm1.AnnotateClick(Sender: TObject);
begin
  if annotate.Checked then begin
    if highres.Checked then
      textid := xlisetting.GFX_AddText(100,100,$FFFFFF00, 'Hello World',100)
    else
      textid := xlisetting.GFX_AddText(50,50,$FFFFFF00, 'Hello World',50);
  end
  else
    xlisetting.GFX_DeleteID(textid);
end;

end.
